// ADOBE SYSTEMS INCORPORATED
// Copyright  1993 - 2002 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this
// file in accordance with the terms of the Adobe license agreement
// accompanying it.  If you have received this file from a source
// other than Adobe, then your use, modification, or distribution
// of it requires the prior written permission of Adobe.

#include "PIDefines.h"

#define plugInName "Save As NxPNG"
#define plugInCopyrightYear	"2000"
#define plugInDescription \
	"An Actions Module to get info from Adobe Photoshop."

#ifdef __PIMac__
	#include "Types.r"
	#include "SysTypes.r"
	#include "PIGeneral.r"
	#include "PIUtilities.r"
	#include "DialogUtilities.r"
#elif defined(__PIWin__)
	#define Rez
	#include "PIGeneral.h"
	#include "PIUtilities.r"
	#include "WinDialogUtils.r"
#endif

#include "PIActions.h"

resource 'PiPL' ( 20000, "Save as NxPNG", purgeable)
	{
		{
		Kind { Actions },
		Name { plugInName },
		Category { "Neversoft" },
		Version { (latestActionsPlugInVersion << 16) | latestActionsPlugInSubVersion },

		#ifdef __PIMac__
			#if TARGET_CARBON
		        CodeCarbonPowerPC { 0, 0, "" },
		    #else
				CodePowerPC { 0, 0, "" },		
			#endif
		#elif defined(__PIWin__)
			CodeWin32X86 { "PluginMain" },
		#endif

		EnableInfo { "true" },//if true, enables plug-in when there's open document
							//if unspecified, plug-in always enabled
		
		HasTerminology
			{ 
			'get ', 
			'getr', 
			20000, 
			"559ac2e6-82d1-11d5-9879-00b0d0204936"
			},
		}
	};

//-------------------------------------------------------------------------------
//	Dictionary (scripting) resource
//-------------------------------------------------------------------------------

resource 'aete' (20000, "Save As NxPNG", purgeable)
	{
	1, 0, english, roman,					/* aete version and language specifiers */
		{
		"Testing",							/* vendor suite name */
		"Adobe example plug-ins",			/* optional description */
		'get ',						/* suite ID */
		1,									/* suite code, must be 1 */
		1,									/* suite level, must be 1 */
			{								/* structure for automation */
			plugInName,						/* name */
			"No comment",					/* optional description */
			'get ',					/* class ID, must be unique or Suite ID */
			'getr',					/* event ID, must be unique */

			NO_REPLY,						/* never a reply */
			IMAGE_DIRECT_PARAMETER,			/* direct parameter, used by Photoshop */
				{							// filter or selection class here:
				}
			},
			{},	/* non-filter/automation plug-in class here */
			{}, /* comparison ops (not supported) */
			{ // Enumerations go here:
			}	/* end of any enumerations */
		}
	};
// end GetterPiPL.r
